/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.LinkedList;
import org.j3d.loaders.stl.STLParser;
import replicatorg.app.Base;

public class STLASCIIParser2
extends STLParser {
    StreamTokenizer facetTokenizer = null;

    @Override
    public void close() throws IOException {
        this.facetTokenizer = null;
    }

    private boolean scanForWord(String word) throws IOException {
        int tt = this.facetTokenizer.nextToken();
        while (tt == -3 && !word.equals(this.facetTokenizer.sval)) {
            tt = this.facetTokenizer.nextToken();
        }
        return tt == -3;
    }

    private boolean readVector(double[] vector) throws IOException {
        int i = 0;
        while (i < 3) {
            int tt = this.facetTokenizer.nextToken();
            if (tt != -3) {
                return false;
            }
            vector[i] = Double.parseDouble(this.facetTokenizer.sval);
            ++i;
        }
        return true;
    }

    @Override
    public boolean getNextFacet(double[] normal, double[][] vertices) throws InterruptedIOException, IOException {
        if (!this.scanForWord("facet")) {
            return false;
        }
        if (!this.scanForWord("normal")) {
            return false;
        }
        if (!this.readVector(normal)) {
            return false;
        }
        int i = 0;
        while (i < 3) {
            if (!this.scanForWord("vertex")) {
                return false;
            }
            if (!this.readVector(vertices[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private StreamTokenizer getNewTokenizer(URL url) throws IOException {
        InputStream stream = null;
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            if (stream != null) {
                stream.close();
            }
            throw e;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(stream)));
        tokenizer.resetSyntax();
        tokenizer.eolIsSignificant(false);
        tokenizer.wordChars(33, 126);
        tokenizer.whitespaceChars(0, 32);
        return tokenizer;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean parse(URL url) throws IOException {
        tokenizer = this.getNewTokenizer(url);
        stats = new LinkedList<ObjectStats>();
        os = this.readObjectStats(tokenizer);
        if (os != null) ** GOTO lbl9
        return false;
lbl-1000:
        // 1 sources

        {
            stats.add(os);
            os = this.readObjectStats(tokenizer);
lbl9:
            // 2 sources

            ** while (os != null)
        }
lbl10:
        // 1 sources

        this.itsNumOfObjects = stats.size();
        this.itsNumOfFacets = new int[this.itsNumOfObjects];
        this.itsNames = new String[this.itsNumOfObjects];
        idx = 0;
        for (ObjectStats s : stats) {
            this.itsNumOfFacets[idx] = s.facets;
            this.itsNames[idx] = s.name;
            ++idx;
        }
        this.facetTokenizer = this.getNewTokenizer(url);
        return true;
    }

    private static boolean hasNonAscii(String s) {
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c > '\u007f') {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ObjectStats readObjectStats(StreamTokenizer t) throws IOException {
        int tt = t.nextToken();
        if (tt != -3) {
            return null;
        }
        if (!"solid".equals(t.sval)) {
            return null;
        }
        ObjectStats os = new ObjectStats();
        StringBuffer nameBuf = null;
        tt = t.nextToken();
        while (tt == -3 && !"facet".equals(t.sval)) {
            if (STLASCIIParser2.hasNonAscii(t.sval)) {
                return null;
            }
            if (nameBuf == null) {
                nameBuf = new StringBuffer(t.sval);
            } else {
                nameBuf.append(' ');
                nameBuf.append(t.sval);
            }
            tt = t.nextToken();
        }
        if (nameBuf != null) {
            os.name = nameBuf.toString();
        }
        Base.logger.info("Got name " + os.name);
        while (tt == -3 && "facet".equals(t.sval)) {
            tt = t.nextToken();
            ++os.facets;
            while (tt == -3 && !"endfacet".equals(t.sval)) {
                tt = t.nextToken();
            }
            tt = t.nextToken();
        }
        if (!"endsolid".equals(t.sval)) {
            return null;
        }
        tt = t.nextToken();
        while (tt == -3 && !"solid".equals(t.sval)) {
            tt = t.nextToken();
        }
        if (tt == -3) {
            t.pushBack();
        }
        Base.logger.info("Parsed object name[" + os.name + "] facets " + Integer.toString(os.facets));
        return os;
    }

    @Override
    public boolean parse(URL url, Component parentComponent) throws InterruptedIOException, IOException {
        return this.parse(url);
    }

    class ObjectStats {
        public String name = "";
        public int facets = 0;

        ObjectStats() {
        }
    }
}

